using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Keyless]
public partial class VwRptPlantStatement
{
    public DateOnly? ProductionMonth { get; set; }

    public DateOnly? StatementDate { get; set; }

    [Column(TypeName = "citext")]
    public string? Plant { get; set; }

    [Column(TypeName = "citext")]
    public string? Meter { get; set; }

    [Column(TypeName = "citext")]
    public string? Producer { get; set; }

    [Column(TypeName = "citext")]
    public string? PayoutType { get; set; }

    [Column(TypeName = "citext")]
    public string? ProcessorOrInletPipe { get; set; }

    public int? WellheadVolumeMcf { get; set; }

    public int? WellheadVolumeMmbtu { get; set; }

    public int? PipelineVolume { get; set; }

    public decimal? ProcessedVolumeMcf { get; set; }

    public decimal? ProcessedVolumeMmbtu { get; set; }

    public decimal? ShrinkMcf { get; set; }

    public decimal? ShrinkMmbtu { get; set; }

    public decimal? PlantFuelMcf { get; set; }

    public decimal? PlantFuelMmbtu { get; set; }

    public decimal? FlareMcf { get; set; }

    public decimal? FlareMmbtu { get; set; }

    public decimal? BypassMcf { get; set; }

    public decimal? BypassMmbtu { get; set; }

    public decimal? PlantGainLossMcf { get; set; }

    public decimal? PlantGainLossMmbtu { get; set; }

    public decimal? ElectionMcf { get; set; }

    public decimal? ElectionMmbtu { get; set; }

    public decimal? PipelineGainLossMcf { get; set; }

    public decimal? PipelineGainLossMmbtu { get; set; }

    public int? InKindPvrMcf { get; set; }

    public int? InKindPtrMmbtu { get; set; }

    public decimal? RecoveredCarbonDioxide { get; set; }

    public decimal? RecoveredEthane { get; set; }

    public decimal? RecoveredPropane { get; set; }

    public decimal? RecoveredIsoButane { get; set; }

    public decimal? RecoveredNormalButane { get; set; }

    public decimal? RecoveredNaturalGasoline { get; set; }

    public decimal? RecoveredScrubber { get; set; }

    public decimal? AllocatedCarbonDioxide { get; set; }

    public decimal? AllocatedEthane { get; set; }

    public decimal? AllocatedPropane { get; set; }

    public decimal? AllocatedIsoButane { get; set; }

    public decimal? AllocatedNormalButane { get; set; }

    public decimal? AllocatedNaturalGasoline { get; set; }

    public decimal? AllocatedScrubber { get; set; }

    public decimal? TheoreticalCarbonDioxide { get; set; }

    public decimal? TheoreticalEthane { get; set; }

    public decimal? TheoreticalPropane { get; set; }

    public decimal? TheoreticalIsoButane { get; set; }

    public decimal? TheoreticalNormalButane { get; set; }

    public decimal? TheoreticalIsoPentane { get; set; }

    public decimal? TheoreticalNormalPentane { get; set; }

    public decimal? TheoreticalNaturalGasoline { get; set; }

    public decimal? EthanePrice { get; set; }

    public decimal? PropanePrice { get; set; }

    public decimal? IsoButanePrice { get; set; }

    public decimal? NormalButanePrice { get; set; }

    public decimal? NaturalGasolinePrice { get; set; }

    public decimal? ScrubberPrice { get; set; }

    public decimal? PtrCashoutPrice { get; set; }

    public decimal? WellheadPtrPrice { get; set; }

    public decimal? PtrFuelPercent { get; set; }

    public decimal? PtrTrans { get; set; }

    public decimal? LiquidsTakePercent { get; set; }

    public decimal? Taxes { get; set; }

    public decimal? FractionationFee { get; set; }

    public decimal? PlantProcessingFee { get; set; }

    public decimal? CarbonDioxideFee { get; set; }

    public decimal? CompressionFee { get; set; }

    public decimal? ElectricityFee { get; set; }

    public decimal? StabilizationFee { get; set; }

    public decimal? MiscellaneousFees { get; set; }

    public decimal? LiquidsLiftingFee { get; set; }

    public bool? ChargeProducerFee { get; set; }

    public decimal? GpmCarbonDioxide { get; set; }

    public decimal? GpmEthane { get; set; }

    public decimal? GpmPropane { get; set; }

    public decimal? GpmIsoButane { get; set; }

    public decimal? GpmNormalButane { get; set; }

    public decimal? GpmIsoPentane { get; set; }

    public decimal? GpmNormalPentane { get; set; }

    public decimal? GpmHexanePlus { get; set; }

    public decimal? MolePercentNitrogen { get; set; }

    public decimal? MolePercentCarbonDioxide { get; set; }

    public decimal? MolePercentMethane { get; set; }

    public decimal? MolePercentEthane { get; set; }

    public decimal? MolePercentPropane { get; set; }

    public decimal? MolePercentIsoButane { get; set; }

    public decimal? MolePercentNormalButane { get; set; }

    public decimal? MolePercentIsoPentane { get; set; }

    public decimal? MolePercentNormalPentane { get; set; }

    public decimal? MolePercentHexane { get; set; }

    public decimal? MolePercentHeptane { get; set; }

    public DateOnly? ProducerFeeContractDate { get; set; }

    public DateOnly? ProducerFeeEffectiveDate { get; set; }

    public decimal? ProducerBaseFee { get; set; }

    public decimal? ProducerIncFee { get; set; }

    [Column(TypeName = "citext")]
    public string? ProducerFeeType { get; set; }

    public decimal? Ratio { get; set; }

    [Column(TypeName = "citext")]
    public string? StatementNotes { get; set; }

    [Column(TypeName = "citext")]
    public string? PlantNotes { get; set; }

    public int? PlantId { get; set; }

    public int? ProducerId { get; set; }

    public int? MeterId { get; set; }
}
