using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("security_group_permission")]
[Index("SecurityGroupId", "SecurityActionId", Name = "uk_security_group_permission", IsUnique = true)]
public partial class SecurityGroupPermission
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("security_group_id")]
    public int SecurityGroupId { get; set; }

    [Column("security_action_id")]
    public int SecurityActionId { get; set; }

    [Column("is_allowed")]
    public bool IsAllowed { get; set; }

    [Column("is_view_allowed")]
    public bool IsViewAllowed { get; set; }

    [Column("is_modify_allowed")]
    public bool IsModifyAllowed { get; set; }

    [ForeignKey("SecurityActionId")]
    [InverseProperty("SecurityGroupPermissions")]
    public virtual SecurityAction SecurityAction { get; set; } = null!;

    [ForeignKey("SecurityGroupId")]
    [InverseProperty("SecurityGroupPermissions")]
    public virtual SecurityGroup SecurityGroup { get; set; } = null!;
}
