using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("security_action")]
[Index("Name", Name = "uk_security_action", IsUnique = true)]
public partial class SecurityAction
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("is_view")]
    public bool IsView { get; set; }

    [Column("display_order")]
    public int? DisplayOrder { get; set; }

    [InverseProperty("SecurityAction")]
    public virtual ICollection<Screen> Screens { get; set; } = new List<Screen>();

    [InverseProperty("SecurityAction")]
    public virtual ICollection<SecurityGroupPermission> SecurityGroupPermissions { get; set; } = new List<SecurityGroupPermission>();
}
