using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipe_contract_receipt_meter")]
[Index("PipeContractId", "MeterId", Name = "idx_26872_UK_PipeContractReceiptMeters", IsUnique = true)]
public partial class PipeContractReceiptMeter
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("pipe_contract_id")]
    public int PipeContractId { get; set; }

    [Column("meter_id")]
    public int MeterId { get; set; }

    [ForeignKey("MeterId")]
    [InverseProperty("PipeContractReceiptMeters")]
    public virtual Meter Meter { get; set; } = null!;

    [ForeignKey("PipeContractId")]
    [InverseProperty("PipeContractReceiptMeters")]
    public virtual PipelineContract PipeContract { get; set; } = null!;
}
