using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipe_contract_doc")]
[Index("PipeContractId", "FileNameOnDisk", Name = "uk_pipe_contract_doc", IsUnique = true)]
public partial class PipeContractDoc
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("pipe_contract_id")]
    public int PipeContractId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string FileNameOriginal { get; set; } = null!;

    [Column("file_name_on_disk", TypeName = "citext")]
    public string FileNameOnDisk { get; set; } = null!;

    [ForeignKey("PipeContractId")]
    [InverseProperty("PipeContractDocs")]
    public virtual PipelineContract PipeContract { get; set; } = null!;
}
