using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("market_index_alias")]
[Index("IndexId", "IndexAlias", "IndexAliasTypeId", Name = "uk_market_index_alias_index", IsUnique = true)]
[Index("IndexAlias", "IndexAliasTypeId", Name = "uq_market_index_alias", IsUnique = true)]
public partial class MarketIndexAlias
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("index_id")]
    public int IndexId { get; set; }

    [Column("index_alias", TypeName = "citext")]
    public string IndexAlias { get; set; } = null!;

    [Column("index_alias_type_id")]
    public int IndexAliasTypeId { get; set; }

    [ForeignKey("IndexId")]
    [InverseProperty("MarketIndexAliases")]
    public virtual MarketIndex Index { get; set; } = null!;

    [ForeignKey("IndexAliasTypeId")]
    [InverseProperty("MarketIndexAliases")]
    public virtual MarketIndexAliasType IndexAliasType { get; set; } = null!;
}
