using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("credit_limit_collateral_doc")]
public partial class CreditLimitCollateralDoc
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("credit_limit_collateral_id")]
    public int CreditLimitCollateralId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string FileNameOriginal { get; set; } = null!;

    [Column("file_name_on_disk", TypeName = "citext")]
    public string FileNameOnDisk { get; set; } = null!;

    [ForeignKey("CreditLimitCollateralId")]
    [InverseProperty("CreditLimitCollateralDocs")]
    public virtual CreditLimitCollateral CreditLimitCollateral { get; set; } = null!;
}
