using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("broker_account")]
public partial class BrokerAccount
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("broker_id", TypeName = "citext")]
    public string? BrokerId { get; set; }

    [Column("cash")]
    public double? Cash { get; set; }

    [Column("letter_of_credit")]
    public double? LetterOfCredit { get; set; }

    [InverseProperty("BrokerAccount")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
