using Fast.Web;
using Fast.Web.Models;
using Microsoft.OData.Edm;
using Microsoft.OData.ModelBuilder;

Main.CustomEdmModel = Helper.GetCustomEdmModel();
Main.DirectoriesToCreate = Helper.GetDirectoriesToCreate();
Main.Configure(args, Type.GetType("Fast.Web.Logic.JobsHelper"));
await Main.RunAsync();

namespace Fast.Web
{
    public static class Helper
    {
        public static string[] GetDirectoriesToCreate()
        {
            return new string[] {
                "Invoices/Crude",
                "Invoices/Gas",
                "InvoiceTemplates",
                "Signatures"
            };
        }

        public static IEdmModel GetCustomEdmModel()
        {
            var builder = new ODataConventionModelBuilder();

            builder.Function("GetInvoiceGasGridItems").Returns<InvoiceGasGridItem>();
            builder.Function("GetInvoiceCrudeGridItems").Returns<InvoiceCrudeGridItem>();
            builder.Function("Test").Returns<InvoiceGasGridItem>();

            return builder.GetEdmModel();
        }
    }
}
