using System.ComponentModel.DataAnnotations;

namespace Fast.Web.Models;

public class MainInvoice
{
    public int Id { get; set; }
    [Display(Name = "Invoice Number")] public string InvoiceNum { get; set; } = string.Empty;
    [Display(Name = "Month")] public DateOnly Month { get; set; }
    public int InternalEntityId { get; set; }
    [Display(Name = "Internal Entity")] public string InternalEntity { get; set; } = string.Empty;
    public int CounterpartyId { get; set; }
    [Display(Name = "Counterparty")] public string Counterparty { get; set; } = string.Empty;
    public int InvoiceTypeId { get; set; }
    [Display(Name = "Invoice Type")] public string InvoiceType { get; set; } = string.Empty;
    [Display(Name = "Invoice Date")] public DateOnly InvoiceDate { get; set; }
    [Display(Name = "Due Date")] public DateOnly? DueDate { get; set; }
    public int? ContractPaymentTypeId { get; set; }
    public string? ContractPaymentType { get; set; }
    public string? FileNameOriginal { get; set; }
    public string? FileNameOnDisk { get; set; }
    [Display(Name = "Approved")] public string IsApproved { get; set; } = "";
    public int? EmailedBy { get; set; }
    [Display(Name = "Emailed By")] public string? EmailedByName { get; set; }
    [Display(Name = "Emailed Time", Description = "150,1,dateTime")] public DateTime? EmailedTime { get; set; }
    public string? ContactTelephoneNum { get; set; }
    public string? ContactName { get; set; }
    public string? ContactEmail { get; set; }
    public string? CustomerNum { get; set; }
    public string? InternalEntityAddressLine1 { get; set; }
    public string? InternalEntityAddressLine2 { get; set; }
    public string? InternalEntityCity { get; set; }
    public string? InternalEntityZip { get; set; }
    public int? InternalEntityCountryId { get; set; }
    public string? InternalEntityCountry { get; set; }
    public int? InternalEntityStateId { get; set; }
    public string? InternalEntityState { get; set; }
    public string? InternalEntityAttn { get; set; }
    public string? InternalEntityTelephoneNum { get; set; }
    public string? InternalEntityFaxNum { get; set; }
    public string? InternalEntityEmailAddress { get; set; }
    public string? CounterpartyAddressLine1 { get; set; }
    public string? CounterpartyAddressLine2 { get; set; }
    public string? CounterpartyCity { get; set; }
    public string? CounterpartyZip { get; set; }
    public int? CounterpartyCountryId { get; set; }
    public string? CounterpartyCountry { get; set; }
    public int? CounterpartyStateId { get; set; }
    public string? CounterpartyState { get; set; }
    public string? CounterpartyAttn { get; set; }
    public string? CounterpartyTelephoneNum { get; set; }
    public string? CounterpartyFaxNum { get; set; }
    public string? CounterpartyEmailAddresses { get; set; }
    public string? PaymentBankName { get; set; }
    public string? PaymentCityState { get; set; }
    public string? PaymentAbaNumWire { get; set; }
    public string? PaymentAbaNumAch { get; set; }
    public string? PaymentAccountName { get; set; }
    public string? PaymentForFurtherCreditTo { get; set; }
    public string? PaymentCreditName { get; set; }
    public string? PaymentAccountNum { get; set; }
    public string? AccountingContactName { get; set; }
    public string? AccountingContactPhone { get; set; }
    public string? AccountingContactEmail { get; set; }
    public decimal? Subtotal { get; set; }
    public decimal? SalesTaxRate { get; set; }
    public decimal? SalesTaxAmount { get; set; }
    public decimal? GrandTotal { get; set; }
    public string? Notes { get; set; }
    public decimal? TotalQuantity { get; set; }
    public decimal? ActualVolume { get; set; }
    public decimal? UsageDiff { get; set; }
}
