using System.ComponentModel.DataAnnotations;

namespace Fast.Web.Models;

public class InvoiceCrudeGridItem
{
    public int? Id { get; set; }
    [Display(Name = "Invoice Number")] public string? InvoiceNum { get; set; }
    [Display(Name = "Traders")] public string? Traders { get; set; }
    [Display(Name = "Month")] public DateOnly Month { get; set; }
    public int InternalEntityId { get; set; }
    [Display(Name = "Internal Entity")] public string InternalEntity { get; set; } = string.Empty;
    public int CounterpartyId { get; set; }
    [Display(Name = "Counterparty")] public string Counterparty { get; set; } = string.Empty;
    [Display(Name = "Invoice Type")] public string InvoiceType { get; set; } = string.Empty;
    [Display(Name = "Due Date")] public DateOnly? DueDate { get; set; }
    public string? FileNameOriginal { get; set; }
    public string? FileNameOnDisk { get; set; }
    [Display(Name = "Approved")] public string IsApproved { get; set; } = "";
    [Display(Name = "Emailed By")] public string? EmailedByName { get; set; }
    [Display(Name = "Emailed Time", Description = "150,1,dateTime")] public DateTime? EmailedTime { get; set; }
    [Display(Name = "Email Addresses")] public string? CounterpartyEmailAddresses { get; set; }
    public bool IsChecked { get; set; }
    public int? ContractId { get; set; }
    public string? SummaryInfo { get; set; }
    public decimal? Subtotal { get; set; }
    public decimal? TotalQuantity { get; set; }
    public decimal? QuantityDifference { get; set; }
    public decimal? AmountDifference { get; set; }
}
