using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Fast.Web.Models
{
    public class BcInvoice
    {
        public string Number { get; set; } = "";
        public int CounterpartyId; //not a get-set property so it's not included in JSON
        public int InternalEntityId; //not a get-set property so it's not included in JSON
        public string? ExternalDocumentNumber { get; set; }
        public string? CustomerNum { get; set; }
        public DateOnly DocumentDate { get; set; }
        public DateOnly PostingDate { get; set; }
        public DateOnly? DueDate { get; set; }
        public decimal? SalesTaxAmount; // not a get-set property
        public decimal? GrandTotal; // not a get-set property
        public List<BcInvoiceLine> InvoiceLines { get; set; } = new List<BcInvoiceLine>();
    }

    public class BcInvoiceLine
    {
        public string? LineType { get; set; }
        public string? LineTypeNumber { get; set; }
        public decimal? UnitPrice { get; set; }
        public string? TaxCode { get; set; }
        public decimal? Quantity { get; set; }
        public string? ProdMonth { get; set; } // shortcut dimension 1, code is PROD MTH
        public string? MeterCode { get; set; } // shortcut dimension 3, code is METER
        public string? StateLocation { get; set; } // shortcut dimension 4, code is STATE LOC
        public string? PdealNumber { get; set; } // shortcut dimension 5, code is PDEAL#
        public string? SdealNumber { get; set; } // shortcut dimension 6, code is SDEAL#
        public string? PipeCode { get; set; } // shortcut dimension 7, code is PIPE
    }
}
