using Fast.Web.Logic.NaturalGas;
using Microsoft.AspNetCore.Mvc;

namespace Fast.Web.Controllers;

[Route("api/[controller]")]
[ApiController]
public class GasSnapshotLinesController(MyDbContext context, IWebHostEnvironment env) : ControllerBase
{
    private readonly MyDbContext db = context;
    private readonly IWebHostEnvironment env = env;

    [HttpGet("GetSnapshotLines")]
    public async Task<IActionResult> GetSnapshotLines(int invoiceId)
    {
        var helper = new InvoiceLineHelper();
        var lines = await helper.GetSnapshotLinesAsync(invoiceId);
        return Ok(lines);
    }
}