import { Pipe, PipeTransform } from '@angular/core';
import { Meter } from '../_shared/utils/util';

@Pipe({
  name: 'pipelineMeters'
})
export class PipelineMetersPipe implements PipeTransform {
  transform(pipelineId: number, meters: Meter[]): Meter[] {
    if (!pipelineId || !meters || typeof pipelineId === "string")
      return [];

    const pipelineMeters = meters.filter(meter => meter.pipeId === pipelineId);
    return pipelineMeters;
  }
}
