import { Pipe, PipeTransform } from '@angular/core';
import { dealNums } from '../invoice-gas-detail/invoice-gas-detail.service';

@Pipe({
    name: 'dealTrader'
})
export class DealTraderPipe implements PipeTransform {
    transform(dealId: number, dealNums: dealNums[]): string {
        if (!dealId || !dealNums) {
            return '';
        }

        const deal = dealNums.find(d => d.id === dealId);
        return deal ? deal.trader : '';
    }
}