import { Injectable, inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { InvoiceGasLineItem } from './models/InvoiceGasLineItem';

@Injectable({
    providedIn: 'root'
})
export class GasSnapshotLinesService {
    private http = inject(HttpClient);
    private baseUrl = `${window.location.origin}/api/GasSnapshotLines`;

    getSnapshotLines(invoiceId: number): Observable<InvoiceGasLineItem[]> {
        const url = `${this.baseUrl}/GetSnapshotLines?invoiceId=${invoiceId}`;
        return this.http.get<InvoiceGasLineItem[]>(url);
    }
}
