import { inject, Injectable } from "@angular/core";
import { Observable } from "rxjs";
import { OdataGridHelper } from "../_shared/utils/odata-grid-helper";
import { HttpClient } from "@angular/common/http";

export interface DistributeResponse {
  hasErrors: boolean;
  message: string;
}

export interface InvoiceSelection {
  id: number;
}

export interface GridItem {
  id: number;
  invoiceNum: string;
  month: string;
  internalEntityId: number;
  internalEntity: string;
  counterpartyId: number;
  counterparty: string;
  invoiceType: string;
  dueDate: Date;
  fileNameOriginal: string;
  fileNameOnDisk: string;
  isApproved: string;
  emailedByName: string;
  emailedTime: string;
  counterpartyEmailAddress: string;
  isChecked: boolean;
}


@Injectable({
  providedIn: 'root'
})
export class CrudeInvoiceDistributeService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/CrudeInvoiceDistribute`;
  http = inject(HttpClient);

  constructor() {
    super()
  }

  getItems(mySelection: number[]): Observable<GridItem[]> {
    const url = `${this.baseUrl}/GetItems`;
    return this.http.put<GridItem[]>(url, mySelection);
  }

  distribute(invoiceSelections: InvoiceSelection[]): Observable<DistributeResponse> {
    const url = `${this.baseUrl}/Distribute`;
    return this.http.put<DistributeResponse>(url, invoiceSelections);
  }
}
