import { ChangeDetectionStrategy, Component, inject, OnInit, signal } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { GasSnapshotLinesComponent } from "../gas-snapshot-lines/gas-snapshot-lines.component";

// This primarily helps with testing child components in isolation
// The test component URL is https://127.0.0.1:{port}/#/Test/{tag} where {tag} is one of the strings below, without quotes
// To hide the theme picker add the topless query parameter with a value of 1: https://127.0.0.1:{port}/#/Test/{tag}?topless=1
// The tag determines which child component is rendered

@Component({
  changeDetection: ChangeDetectionStrategy.OnPush,
  template: `
    <div id="container" class="bg-base-white-250 col-g hideOverflow">
      @if(!tag()) { <h1 class="text-base-black-750">place a test component tag with a tag conditional here: E.G. <div>{{exampleComponentHtmlString}}</div></h1> }
      @if(tag() === "GasSnapshot") { <gas-snapshot-lines [invoiceId]="410" invoiceNum="DRAFT-496"> </gas-snapshot-lines> }
    </div>
  `,
  styles: `
    app-test { background-color: gray; height: 100%; }
    app-test #container > * { display: flex; flex-grow: 1; flex-direction: column; height: 100%; }
  `,
  selector: 'app-test',
  imports: [GasSnapshotLinesComponent]
})
export class TestComponent implements OnInit {
  exampleComponentHtmlString = `
    @if (tag() === 'approval-docs') { <app-approval-docs [creditLimitId]="361"></app-approval-docs> }
  `;
  route = inject(ActivatedRoute);
  tag = signal<string>(null);

  ngOnInit(): void {
    this.route.params.subscribe(params => {
      this.tag.set(params['tag']);
    });
  }
}
