import { inject, Injectable } from '@angular/core';
import { HttpRequest, HttpHandler, HttpEvent, HttpInterceptor } from '@angular/common/http';
import { Observable } from 'rxjs';
import { LoggerService } from './services/logger.service';

@Injectable()
export class TokenInterceptor implements HttpInterceptor {
  // REMOVE OAuthService injection: private readonly oauthService = inject(OAuthService);
  logger = inject(LoggerService);

  intercept(
    request: HttpRequest<unknown>,
    next: HttpHandler
  ): Observable<HttpEvent<unknown>> {
    this.logger.log('TokenInterceptor: RAW request URL:', request.url);
    // In BFF, the browser automatically attaches the 'FastAppBffCookie'
    // to requests to the same origin.
    // We no longer need to manually add an Authorization: Bearer header to our backend.
    // If you were calling *other* APIs (not your BFF) from Angular, you'd need a separate mechanism.

    // If you need to add any other headers, do it here:
    // const clonedRequest = request.clone({
    //   setHeaders: {
    //     'X-Custom-Header': 'SomeValue'
    //   }
    // });
    // return next.handle(clonedRequest);

    // console.log('TokenInterceptor: Headers *before* next.handle (cookie attached automatically by browser):',
    //   request.headers.keys().map(k => `${k}: ${request.headers.get(k)}`));
    return next.handle(request);
  }
}
