import { Injectable } from '@angular/core';

@Injectable({
    providedIn: 'root'
})
export class LoggerService {

    // To see debug logs run below in the browser console
    // localStorage.setItem('FAST_DEBUG', 'true')
    // localStorage.removeItem('FAST_DEBUG')
    private readonly debugKey = 'FAST_DEBUG';

    constructor() { }

    private isDebugEnabled(): boolean {
        return localStorage.getItem(this.debugKey) === 'true';
    }

    log(message: unknown, ...optionalParams: unknown[]) {
        if (this.isDebugEnabled()) {
            console.log(message, ...optionalParams);
        }
    }

    warn(message: unknown, ...optionalParams: unknown[]) {
        if (this.isDebugEnabled()) {
            console.warn(message, ...optionalParams);
        }
    }

    error(message: unknown, ...optionalParams: unknown[]) {
        // Errors are important and we usually want to see errors regardless of debug mode.
        console.error(message, ...optionalParams);
    }
}
