import { Pipe, PipeTransform } from '@angular/core';
import { kendoFormatNumber } from '../utils/util';

@Pipe({
  name: 'kFormatNum'
})
export class KFormatNumPipe implements PipeTransform {
  transform(num: string | number, format: string): string {
    let returnStr: string;

    if (typeof num == 'string')
      returnStr = kendoFormatNumber(parseFloat(num), format);
    else
      returnStr = kendoFormatNumber(num, format);

    return returnStr;
  }
}
