import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
    name: 'hasDifferences',
    pure: true,
    standalone: true
})
export class HasDifferencesPipe implements PipeTransform {
    transform(dataItem: { AmountDifference?: number | null; QuantityDifference?: number | null }): boolean {
        const amount = dataItem.AmountDifference !== 0 && dataItem.AmountDifference !== null;
        const quantity = dataItem.QuantityDifference !== 0 && dataItem.QuantityDifference !== null;

        return amount || quantity;
    }
}
