import { ChangeDetectionStrategy, Component, HostBinding, input, OnChanges, signal } from '@angular/core';
import { twMerge } from 'tailwind-merge';

@Component({
  selector: 'fast-label',
  imports: [],
  template: `
<label [htmlFor]="htmlFor()" [class.cursor-pointer]="hasCursorPointer()">
  <ng-content></ng-content>
</label>
  `,
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class FastLabelComponent implements OnChanges {
  class = input<string>('');
  htmlFor = input<unknown>(null);
  hasCursorPointer = signal<boolean>(false);
  defaultClasses = 'text-sm text-base-black-250 dark:text-base-gray-1000';
  @HostBinding('class') hostClass: string = this.defaultClasses;

  ngOnChanges(): void {
    this.hostClass = twMerge(this.defaultClasses, this.class());
    if (this.hostClass.includes('cursor-pointer'))
      this.hasCursorPointer.set(true);
  }
}
