namespace Fast.Shared.Models;

[Serializable]
public class IdName : IEquatable<IdName>
{
    public int Id;
    public string Name = "";

    public IdName()
    {
    }

    public IdName(int Id, string Name)
    {
        this.Id = Id;
        this.Name = Name;
    }

    public override bool Equals(object? obj)
    {
        return Equals(obj as IdName);
    }

    public bool Equals(IdName? other)
    {
        return Id == other?.Id &&
               Name == other?.Name;
    }

    public override int GetHashCode()
    {
        return HashCode.Combine(Id, Name);
    }

    public static bool operator ==(IdName pair1, IdName pair2)
    {
        return EqualityComparer<IdName>.Default.Equals(pair1, pair2);
    }

    public static bool operator !=(IdName pair1, IdName pair2)
    {
        return !(pair1 == pair2);
    }
}
