namespace Fast.Shared.Logic.ValuationCommon;

[Serializable]
public class ValPriceEquationKey : IEquatable<ValPriceEquationKey>
{
    public string Equation = "";
    public DateOnly Date;
    public Enums.ValPriceType PriceType;

    public ValPriceEquationKey()
    {
    }

    public ValPriceEquationKey(string Equation, DateOnly Date, Enums.ValPriceType PriceType)
    {
        this.Equation = Equation;
        this.Date = Date;
        this.PriceType = PriceType;
    }

    public override bool Equals(object? obj)
    {
        return Equals(obj as IdNameActive);
    }

    public bool Equals(ValPriceEquationKey? other)
    {
        return Equation == other?.Equation &&
               Date == other?.Date &&
               PriceType == other?.PriceType;
    }

    public override int GetHashCode()
    {
        return HashCode.Combine(Equation, Date, PriceType);
    }

    public static bool operator ==(ValPriceEquationKey pair1, ValPriceEquationKey pair2)
    {
        return EqualityComparer<ValPriceEquationKey>.Default.Equals(pair1, pair2);
    }

    public static bool operator !=(ValPriceEquationKey pair1, ValPriceEquationKey pair2)
    {
        return !(pair1 == pair2);
    }
}
