namespace Fast.Shared.Logic.ValuationCommon;

/// <summary>
/// This was created to mimic the standard .net Lazy class but with much greater performance
/// </summary>
public class MyLazy<T>(Func<T> valueFactory)
{
    public bool IsValueCreated { get; private set; }

    public T? Value
    {
        get
        {
            if (!IsValueCreated)
            {
                GetValue();
            }

            return value;
        }
        set
        {
            this.value = value;
            IsValueCreated = true;
        }
    }

    private T? value;

    /// <summary>
    /// Forces a value retrieval.
    /// </summary>
    public void GetValue()
    {
        value = valueFactory();
        IsValueCreated = true;
    }
}
