namespace Fast.Shared.Logic.Valuation;

public class ValuationResultGrouped
{
    public int? DealId { get; set; }
    public int? MasterDealId { get; set; }
    public int? MultiTriggerId { get; set; }
    public string TicketNum { get; set; } = "";
    public string MasterTicketNum { get; set; } = "";
    public double AvgContractPrice { get; set; }
    public double AvgInvoicePrice { get; set; }
    public double AvgMarketPrice { get; set; }
    public double SumPositionAmount { get; set; }
    public double? SumRINPositionAmount { get; set; }
    public double SumNotionalAmount { get; set; }
    public double SumPnL { get; set; }
    public bool MinIsPosted { get; set; }
    public double AvgVolume { get; set; }
    public bool IsMonthlyIndexDeal { get; set; }
    public int? DealPurposeId { get; set; }
    public double LastNonZeroContractPrice { get; set; }
    public double? MonthlyContractPrice { get; set; }
    public double AvgBasis { get; set; }
    public double AvgPremDisc { get; set; }
}

public class ValuationResultGroupedByMonth : ValuationResultGrouped
{
    public DateOnly Month { get; set; }
}
