using Serilog.Core;
using Serilog.Events;


namespace Fast.Shared.Logic;

public class SerilogUserAgentEnricher(IHttpContextAccessor httpContextAccessor) : ILogEventEnricher
{
    private readonly IHttpContextAccessor _httpContextAccessor = httpContextAccessor;

    public void Enrich(LogEvent logEvent, ILogEventPropertyFactory propertyFactory)
    {
        var httpContext = _httpContextAccessor.HttpContext;
        if (httpContext?.Request?.Headers != null)
        {
            var userAgent = httpContext.Request.Headers.UserAgent.ToString();
            var userAgentProperty = new LogEventProperty("ClientAgent", new ScalarValue(userAgent));
            logEvent.AddPropertyIfAbsent(userAgentProperty);
        }
    }
}
