using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Keyless]
public partial class VwRptMeterDatum
{
    [Column("Meter Name", TypeName = "citext")]
    public string? MeterName { get; set; }

    [Column("Meter Numbers", TypeName = "citext")]
    public string? MeterNumbers { get; set; }

    public DateOnly? InactiveDate { get; set; }

    [Column(TypeName = "citext")]
    public string? Plants { get; set; }

    [Column(TypeName = "citext")]
    public string? Producers { get; set; }

    [Column(TypeName = "citext")]
    public string? SourceZoneIds { get; set; }

    [Column("Source Zones", TypeName = "citext")]
    public string? SourceZones { get; set; }

    [Column(TypeName = "citext")]
    public string? SourcePipes { get; set; }

    [Column(TypeName = "citext")]
    public string? PointIds { get; set; }

    [Column(TypeName = "citext")]
    public string? Points { get; set; }

    [Column(TypeName = "citext")]
    public string? HubCodes { get; set; }

    [Column("Meter Types", TypeName = "citext")]
    public string? MeterTypes { get; set; }

    [Column(TypeName = "citext")]
    public string? Lease { get; set; }

    [Column(TypeName = "citext")]
    public string? State { get; set; }

    [Column(TypeName = "citext")]
    public string? Location { get; set; }

    [Column(TypeName = "citext")]
    public string? ProductIds { get; set; }

    [Column(TypeName = "citext")]
    public string? Products { get; set; }
}
