using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("unit_price_combination")]
public partial class UnitPriceCombination
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("currency_type_id")]
    public int CurrencyTypeId { get; set; }

    [Column("unit_of_measure_id")]
    public int UnitOfMeasureId { get; set; }

    [ForeignKey("CurrencyTypeId")]
    [InverseProperty("UnitPriceCombinations")]
    public virtual CurrencyType CurrencyType { get; set; } = null!;

    [InverseProperty("UnitBasisPrice")]
    public virtual ICollection<Deal> DealUnitBasisPrices { get; set; } = new List<Deal>();

    [InverseProperty("UnitFixedPrice")]
    public virtual ICollection<Deal> DealUnitFixedPrices { get; set; } = new List<Deal>();

    [InverseProperty("UnitPremDiscPrice")]
    public virtual ICollection<Deal> DealUnitPremDiscPrices { get; set; } = new List<Deal>();

    [InverseProperty("UnitTaxCredit")]
    public virtual ICollection<Deal> DealUnitTaxCredits { get; set; } = new List<Deal>();

    [InverseProperty("UnitPrice")]
    public virtual ICollection<MarketIndex> MarketIndices { get; set; } = new List<MarketIndex>();

    [InverseProperty("UnitPrice")]
    public virtual ICollection<Product> Products { get; set; } = new List<Product>();

    [ForeignKey("UnitOfMeasureId")]
    [InverseProperty("UnitPriceCombinations")]
    public virtual UnitOfMeasure UnitOfMeasure { get; set; } = null!;
}
