using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("transfer_meter")]
[Index("Meter1Id", Name = "ix_transfer_meter_meter_1")]
[Index("Meter2Id", Name = "ix_transfer_meter_meter_2")]
[Index("Meter1Id", "Meter2Id", Name = "uk_transfer_meter_map", IsUnique = true)]
public partial class TransferMeter
{
    [Column("meter1_id")]
    public int Meter1Id { get; set; }

    [Column("meter2_id")]
    public int Meter2Id { get; set; }

    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [InverseProperty("MeterMap")]
    public virtual ICollection<CrudePathRoute> CrudePathRoutes { get; set; } = new List<CrudePathRoute>();

    [InverseProperty("MeterMap")]
    public virtual ICollection<GasPathRoute> GasPathRoutes { get; set; } = new List<GasPathRoute>();

    [ForeignKey("Meter1Id")]
    [InverseProperty("TransferMeterMeter1s")]
    public virtual Meter Meter1 { get; set; } = null!;

    [ForeignKey("Meter2Id")]
    [InverseProperty("TransferMeterMeter2s")]
    public virtual Meter Meter2 { get; set; } = null!;

    [ForeignKey("ProductId")]
    [InverseProperty("TransferMeters")]
    public virtual Product Product { get; set; } = null!;

    [InverseProperty("TransferMeterMap")]
    public virtual ICollection<TransferDeal> TransferDeals { get; set; } = new List<TransferDeal>();
}
