using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("state_income_exemption")]
[Index("CompanyId", "StateId", "ExpirationDate", Name = "uk_state_income_exemption_company_id_state_id_expiration_date", IsUnique = true)]
public partial class StateIncomeExemption
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("company_id")]
    public int CompanyId { get; set; }

    [Column("state_id")]
    public int StateId { get; set; }

    [Column("effective_date")]
    public DateOnly? EffectiveDate { get; set; }

    [Column("expiration_date")]
    public DateOnly ExpirationDate { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [ForeignKey("CompanyId")]
    [InverseProperty("StateIncomeExemptions")]
    public virtual Counterparty Company { get; set; } = null!;

    [ForeignKey("StateId")]
    [InverseProperty("StateIncomeExemptions")]
    public virtual Territory State { get; set; } = null!;

    [InverseProperty("StateIncomeExemption")]
    public virtual ICollection<StateIncomeExemptionDoc> StateIncomeExemptionDocs { get; set; } = new List<StateIncomeExemptionDoc>();
}
