using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("sos_snapshot")]
public partial class SosSnapshot
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("nom_date")]
    public DateOnly NomDate { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [Column("pipe_id")]
    public int PipeId { get; set; }

    [Column("point_id")]
    public int? PointId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string? FileNameOriginal { get; set; }

    [Column("file_name_on_disk", TypeName = "citext")]
    public string? FileNameOnDisk { get; set; }

    [Column("created_by")]
    public int CreatedBy { get; set; }

    [Column("created_time")]
    public DateTime CreatedTime { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [ForeignKey("PipeId")]
    [InverseProperty("SosSnapshots")]
    public virtual Pipeline Pipe { get; set; } = null!;

    [ForeignKey("PointId")]
    [InverseProperty("SosSnapshots")]
    public virtual Point? Point { get; set; }
}
