using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("security_user_group")]
[Index("UserId", "SecurityGroupId", Name = "uk_security_user_group", IsUnique = true)]
public partial class SecurityUserGroup
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("user_id")]
    public int UserId { get; set; }

    [Column("security_group_id")]
    public int SecurityGroupId { get; set; }

    [ForeignKey("SecurityGroupId")]
    [InverseProperty("SecurityUserGroups")]
    public virtual SecurityGroup SecurityGroup { get; set; } = null!;

    [ForeignKey("UserId")]
    [InverseProperty("SecurityUserGroups")]
    public virtual AppUser User { get; set; } = null!;
}
