using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("screen")]
[Index("Description", Name = "uk_screen_description", IsUnique = true)]
public partial class Screen
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("description", TypeName = "citext")]
    public string? Description { get; set; }

    [Column("keywords", TypeName = "citext")]
    public string? Keywords { get; set; }

    [Column("path", TypeName = "citext")]
    public string? Path { get; set; }

    [Column("is_visible")]
    public bool IsVisible { get; set; }

    [Column("parent_id")]
    public int? ParentId { get; set; }

    [Column("security_action_id")]
    public int? SecurityActionId { get; set; }

    [InverseProperty("Parent")]
    public virtual ICollection<Screen> InverseParent { get; set; } = new List<Screen>();

    [ForeignKey("ParentId")]
    [InverseProperty("InverseParent")]
    public virtual Screen? Parent { get; set; }

    [ForeignKey("SecurityActionId")]
    [InverseProperty("Screens")]
    public virtual SecurityAction? SecurityAction { get; set; }

    [InverseProperty("Screen")]
    public virtual ICollection<UserScreenSort> UserScreenSorts { get; set; } = new List<UserScreenSort>();
}
