using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("sales_tax_doc")]
public partial class SalesTaxDoc
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("sales_tax_id")]
    public int SalesTaxId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string FileNameOriginal { get; set; } = null!;

    [Column("file_name_on_disk", TypeName = "citext")]
    public string FileNameOnDisk { get; set; } = null!;

    [ForeignKey("SalesTaxId")]
    [InverseProperty("SalesTaxDocs")]
    public virtual SalesTax SalesTax { get; set; } = null!;
}
