using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("region")]
[Index("Name", Name = "uk_region", IsUnique = true)]
public partial class Region
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("is_active")]
    public bool IsActive { get; set; }

    [InverseProperty("Region")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
