using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("product_expiration")]
public partial class ProductExpiration
{
    [Column("contract_month")]
    public DateOnly ContractMonth { get; set; }

    [Column("expiration_date")]
    public DateOnly? ExpirationDate { get; set; }

    [Column("benchmark_id")]
    public int BenchmarkId { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [Key]
    [Column("id")]
    public int Id { get; set; }

    [ForeignKey("BenchmarkId")]
    [InverseProperty("ProductExpirations")]
    public virtual Benchmark Benchmark { get; set; } = null!;

    [ForeignKey("ProductId")]
    [InverseProperty("ProductExpirations")]
    public virtual Product Product { get; set; } = null!;
}
