using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("producer_fee")]
[Index("ProducerId", "EffectiveDate", Name = "uk_producer_fee_producer", IsUnique = true)]
public partial class ProducerFee
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("producer_id")]
    public int ProducerId { get; set; }

    [Column("contract_date")]
    public DateOnly ContractDate { get; set; }

    [Column("effective_date")]
    public DateOnly EffectiveDate { get; set; }

    [Column("base_fee")]
    public decimal BaseFee { get; set; }

    [Column("inc_fee")]
    public decimal? IncFee { get; set; }

    [Column("fee_type_id")]
    public int FeeTypeId { get; set; }

    [ForeignKey("FeeTypeId")]
    [InverseProperty("ProducerFees")]
    public virtual ProducerFeeType FeeType { get; set; } = null!;

    [ForeignKey("ProducerId")]
    [InverseProperty("ProducerFees")]
    public virtual Counterparty Producer { get; set; } = null!;
}
