using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("portfolio")]
[Index("Name", Name = "uk_portfolio", IsUnique = true)]
public partial class Portfolio
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("is_active")]
    public bool IsActive { get; set; }

    [InverseProperty("Portfolio")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
