using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("plant_statement")]
public partial class PlantStatement
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("production_month")]
    public DateOnly ProductionMonth { get; set; }

    [Column("statement_date")]
    public DateOnly StatementDate { get; set; }

    [Column("plant_id")]
    public int PlantId { get; set; }

    [Column("producer_id")]
    public int ProducerId { get; set; }

    [Column("meter_id")]
    public int? MeterId { get; set; }

    [Column("statement_descriptor_id")]
    public int? StatementDescriptorId { get; set; }

    [Column("payout_type_id")]
    public int? PayoutTypeId { get; set; }

    [Column("wellhead_volume_mcf")]
    public int? WellheadVolumeMcf { get; set; }

    [Column("wellhead_volume_mmbtu")]
    public int? WellheadVolumeMmbtu { get; set; }

    [Column("processed_volume_mcf")]
    public int? ProcessedVolumeMcf { get; set; }

    [Column("processed_volume_mmbtu")]
    public int? ProcessedVolumeMmbtu { get; set; }

    [Column("shrink_mcf")]
    public int? ShrinkMcf { get; set; }

    [Column("shrink_mmbtu")]
    public int? ShrinkMmbtu { get; set; }

    [Column("plant_fuel_mcf")]
    public int? PlantFuelMcf { get; set; }

    [Column("plant_fuel_mmbtu")]
    public int? PlantFuelMmbtu { get; set; }

    [Column("flare_mcf")]
    public int? FlareMcf { get; set; }

    [Column("flare_mmbtu")]
    public int? FlareMmbtu { get; set; }

    [Column("bypass_mcf")]
    public int? BypassMcf { get; set; }

    [Column("bypass_mmbtu")]
    public int? BypassMmbtu { get; set; }

    [Column("plant_gain_loss_mcf")]
    public int? PlantGainLossMcf { get; set; }

    [Column("plant_gain_loss_mmbtu")]
    public int? PlantGainLossMmbtu { get; set; }

    [Column("in_kind_pvr_mcf")]
    public int? InKindPvrMcf { get; set; }

    [Column("in_kind_ptr_mmbtu")]
    public int? InKindPtrMmbtu { get; set; }

    [Column("recovered_carbon_dioxide")]
    public int? RecoveredCarbonDioxide { get; set; }

    [Column("recovered_ethane")]
    public int? RecoveredEthane { get; set; }

    [Column("recovered_propane")]
    public int? RecoveredPropane { get; set; }

    [Column("recovered_iso_butane")]
    public int? RecoveredIsoButane { get; set; }

    [Column("recovered_normal_butane")]
    public int? RecoveredNormalButane { get; set; }

    [Column("recovered_natural_gasoline")]
    public int? RecoveredNaturalGasoline { get; set; }

    [Column("recovered_scrubber")]
    public int? RecoveredScrubber { get; set; }

    [Column("theoretical_carbon_dioxide")]
    public int? TheoreticalCarbonDioxide { get; set; }

    [Column("theoretical_ethane")]
    public int? TheoreticalEthane { get; set; }

    [Column("theoretical_propane")]
    public int? TheoreticalPropane { get; set; }

    [Column("theoretical_iso_butane")]
    public int? TheoreticalIsoButane { get; set; }

    [Column("theoretical_normal_butane")]
    public int? TheoreticalNormalButane { get; set; }

    [Column("theoretical_iso_pentane")]
    public int? TheoreticalIsoPentane { get; set; }

    [Column("theoretical_normal_pentane")]
    public int? TheoreticalNormalPentane { get; set; }

    [Column("theoretical_natural_gasoline")]
    public int? TheoreticalNaturalGasoline { get; set; }

    [Column("ptr_cashout_price")]
    public decimal? PtrCashoutPrice { get; set; }

    [Column("ptr_trans")]
    public decimal? PtrTrans { get; set; }

    [Column("ptr_fuel_percent")]
    public decimal? PtrFuelPercent { get; set; }

    [Column("wellhead_ptr_price")]
    public decimal? WellheadPtrPrice { get; set; }

    [Column("liquids_take_percent")]
    public decimal? LiquidsTakePercent { get; set; }

    [Column("taxes")]
    public decimal? Taxes { get; set; }

    [Column("fractionation_fee")]
    public decimal? FractionationFee { get; set; }

    [Column("plant_processing_fee")]
    public decimal? PlantProcessingFee { get; set; }

    [Column("carbon_dioxide_fee")]
    public decimal? CarbonDioxideFee { get; set; }

    [Column("compression_fee")]
    public decimal? CompressionFee { get; set; }

    [Column("electricity_fee")]
    public decimal? ElectricityFee { get; set; }

    [Column("stabilization_fee")]
    public decimal? StabilizationFee { get; set; }

    [Column("miscellaneous_fees")]
    public decimal? MiscellaneousFees { get; set; }

    [Column("liquids_lifting_fee")]
    public decimal? LiquidsLiftingFee { get; set; }

    [Column("gpm_carbon_dioxide")]
    public decimal? GpmCarbonDioxide { get; set; }

    [Column("gpm_ethane")]
    public decimal? GpmEthane { get; set; }

    [Column("gpm_propane")]
    public decimal? GpmPropane { get; set; }

    [Column("gpm_iso_butane")]
    public decimal? GpmIsoButane { get; set; }

    [Column("gpm_normal_butane")]
    public decimal? GpmNormalButane { get; set; }

    [Column("gpm_iso_pentane")]
    public decimal? GpmIsoPentane { get; set; }

    [Column("gpm_normal_pentane")]
    public decimal? GpmNormalPentane { get; set; }

    [Column("gpm_hexane_plus")]
    public decimal? GpmHexanePlus { get; set; }

    [Column("mole_percent_nitrogen")]
    public decimal? MolePercentNitrogen { get; set; }

    [Column("mole_percent_carbon_dioxide")]
    public decimal? MolePercentCarbonDioxide { get; set; }

    [Column("mole_percent_methane")]
    public decimal? MolePercentMethane { get; set; }

    [Column("mole_percent_ethane")]
    public decimal? MolePercentEthane { get; set; }

    [Column("mole_percent_propane")]
    public decimal? MolePercentPropane { get; set; }

    [Column("mole_percent_iso_butane")]
    public decimal? MolePercentIsoButane { get; set; }

    [Column("mole_percent_normal_butane")]
    public decimal? MolePercentNormalButane { get; set; }

    [Column("mole_percent_iso_pentane")]
    public decimal? MolePercentIsoPentane { get; set; }

    [Column("mole_percent_normal_pentane")]
    public decimal? MolePercentNormalPentane { get; set; }

    [Column("mole_percent_hexane")]
    public decimal? MolePercentHexane { get; set; }

    [Column("mole_percent_heptane")]
    public decimal? MolePercentHeptane { get; set; }

    [Column("pipeline_gain_loss_mcf")]
    public int? PipelineGainLossMcf { get; set; }

    [Column("pipeline_gain_loss_mmbtu")]
    public int? PipelineGainLossMmbtu { get; set; }

    [Column("allocated_carbon_dioxide")]
    public int? AllocatedCarbonDioxide { get; set; }

    [Column("allocated_ethane")]
    public int? AllocatedEthane { get; set; }

    [Column("allocated_propane")]
    public int? AllocatedPropane { get; set; }

    [Column("allocated_iso_butane")]
    public int? AllocatedIsoButane { get; set; }

    [Column("allocated_normal_butane")]
    public int? AllocatedNormalButane { get; set; }

    [Column("allocated_natural_gasoline")]
    public int? AllocatedNaturalGasoline { get; set; }

    [Column("allocated_scrubber")]
    public int? AllocatedScrubber { get; set; }

    [Column("prices_id")]
    public int? PricesId { get; set; }

    [Column("charge_producer_fee")]
    public bool ChargeProducerFee { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [Column("election_mcf")]
    public int? ElectionMcf { get; set; }

    [Column("election_mmbtu")]
    public int? ElectionMmbtu { get; set; }

    [ForeignKey("MeterId")]
    [InverseProperty("PlantStatements")]
    public virtual Meter? Meter { get; set; }

    [ForeignKey("PayoutTypeId")]
    [InverseProperty("PlantStatements")]
    public virtual PayoutType? PayoutType { get; set; }

    [ForeignKey("PlantId")]
    [InverseProperty("PlantStatements")]
    public virtual Plant Plant { get; set; } = null!;

    [InverseProperty("PlantStatement")]
    public virtual ICollection<PlantStatementCombinedMeter> PlantStatementCombinedMeters { get; set; } = new List<PlantStatementCombinedMeter>();

    [ForeignKey("PricesId")]
    [InverseProperty("PlantStatements")]
    public virtual PlantStatementPrice? Prices { get; set; }

    [ForeignKey("ProducerId")]
    [InverseProperty("PlantStatements")]
    public virtual Counterparty Producer { get; set; } = null!;

    [ForeignKey("StatementDescriptorId")]
    [InverseProperty("PlantStatements")]
    public virtual PlantStatementDescriptor? StatementDescriptor { get; set; }
}
