using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("pipeline_type")]
public partial class PipelineType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("PipelineType")]
    public virtual ICollection<Pipeline> Pipelines { get; set; } = new List<Pipeline>();
}
