using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("pipeline_rate_discounted")]
public partial class PipelineRateDiscounted
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("rate_schedule_id")]
    public int RateScheduleId { get; set; }

    [Column("tariff_type_id")]
    public int TariffTypeId { get; set; }

    [Column("effective_date")]
    public DateOnly EffectiveDate { get; set; }

    [Column("end_date")]
    public DateOnly EndDate { get; set; }

    [Column("rate")]
    public double Rate { get; set; }

    [Column("are_all_from_zones_selected")]
    public bool AreAllFromZonesSelected { get; set; }

    [Column("are_all_from_meters_selected")]
    public bool AreAllFromMetersSelected { get; set; }

    [Column("are_all_to_zones_selected")]
    public bool AreAllToZonesSelected { get; set; }

    [Column("are_all_to_meters_selected")]
    public bool AreAllToMetersSelected { get; set; }

    [Column("are_all_counterparty_selected")]
    public bool AreAllCounterpartySelected { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [InverseProperty("PipelineRateDiscounted")]
    public virtual ICollection<PipeDiscountDoc> PipeDiscountDocs { get; set; } = new List<PipeDiscountDoc>();

    [InverseProperty("DiscountedRate")]
    public virtual ICollection<PipelineRateDiscountedCounterparty> PipelineRateDiscountedCounterparties { get; set; } = new List<PipelineRateDiscountedCounterparty>();

    [InverseProperty("DiscountedRate")]
    public virtual ICollection<PipelineRateDiscountedFromTo> PipelineRateDiscountedFromTos { get; set; } = new List<PipelineRateDiscountedFromTo>();

    [ForeignKey("RateScheduleId")]
    [InverseProperty("PipelineRateDiscounteds")]
    public virtual PipelineRateSchedule RateSchedule { get; set; } = null!;

    [ForeignKey("TariffTypeId")]
    [InverseProperty("PipelineRateDiscounteds")]
    public virtual PipelineTariffType TariffType { get; set; } = null!;
}
