using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("meter_ptr_excluded")]
public partial class MeterPtrExcluded
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("meter_ptr_id")]
    public int MeterPtrId { get; set; }

    [Column("counterparty_id")]
    public int CounterpartyId { get; set; }

    [ForeignKey("CounterpartyId")]
    [InverseProperty("MeterPtrExcludeds")]
    public virtual Counterparty Counterparty { get; set; } = null!;

    [ForeignKey("MeterPtrId")]
    [InverseProperty("MeterPtrExcludeds")]
    public virtual MeterPtr MeterPtr { get; set; } = null!;
}
