using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("hypothetical_type")]
public partial class HypotheticalType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("reserved_field1", TypeName = "citext")]
    public string? ReservedField1 { get; set; }

    [Column("reserved_field2", TypeName = "citext")]
    public string? ReservedField2 { get; set; }

    [Column("reserved_field3", TypeName = "citext")]
    public string? ReservedField3 { get; set; }

    [Column("reserved_field4", TypeName = "citext")]
    public string? ReservedField4 { get; set; }

    [Column("reserved_field5", TypeName = "citext")]
    public string? ReservedField5 { get; set; }

    [InverseProperty("Hypothetical")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
