using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("deal_confirmation")]
[Index("TicketNum", Name = "uk_deal_confirmation_ticket", IsUnique = true)]
public partial class DealConfirmation
{
    [Column("ticket_num", TypeName = "citext")]
    public string TicketNum { get; set; } = null!;

    [Column("confirmed_by")]
    public int? ConfirmedBy { get; set; }

    [Column("ticketed_by")]
    public int? TicketedBy { get; set; }

    [Column("faxed_by")]
    public int? FaxedBy { get; set; }

    [Column("confirm_file", TypeName = "citext")]
    public string? ConfirmFile { get; set; }

    [Column("ticket_file", TypeName = "citext")]
    public string? TicketFile { get; set; }

    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("ticket_date")]
    public DateTime? TicketDate { get; set; }

    [Column("confirm_date")]
    public DateTime? ConfirmDate { get; set; }

    [Column("emailed_by")]
    public int? EmailedBy { get; set; }

    [Column("email_date")]
    public DateTime? EmailDate { get; set; }

    [Column("fax_date")]
    public DateTime? FaxDate { get; set; }

    [Column("modification_date")]
    public DateTime? ModificationDate { get; set; }

    [Column("ticket_number")]
    public int? TicketNumber { get; set; }

    [Column("distributed")]
    public DateTime? Distributed { get; set; }

    [Column("confirm_file_name_on_disk", TypeName = "citext")]
    public string? ConfirmFileNameOnDisk { get; set; }

    [Column("ticket_file_name_on_disk", TypeName = "citext")]
    public string? TicketFileNameOnDisk { get; set; }

    [ForeignKey("ConfirmedBy")]
    [InverseProperty("DealConfirmationConfirmedByNavigations")]
    public virtual AppUser? ConfirmedByNavigation { get; set; }

    [ForeignKey("EmailedBy")]
    [InverseProperty("DealConfirmationEmailedByNavigations")]
    public virtual AppUser? EmailedByNavigation { get; set; }

    [ForeignKey("FaxedBy")]
    [InverseProperty("DealConfirmationFaxedByNavigations")]
    public virtual AppUser? FaxedByNavigation { get; set; }

    [ForeignKey("TicketNum")]
    [InverseProperty("DealConfirmation")]
    public virtual Deal TicketNumNavigation { get; set; } = null!;

    [ForeignKey("TicketedBy")]
    [InverseProperty("DealConfirmationTicketedByNavigations")]
    public virtual AppUser? TicketedByNavigation { get; set; }
}
