using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("credit_limit_collateral_beneficiary")]
[Index("CreditLimitCollateralId", "BeneficiaryId", Name = "uk_credit_limit_collateral_beneficiary", IsUnique = true)]
public partial class CreditLimitCollateralBeneficiary
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("credit_limit_collateral_id")]
    public int CreditLimitCollateralId { get; set; }

    [Column("beneficiary_id")]
    public int BeneficiaryId { get; set; }

    [ForeignKey("BeneficiaryId")]
    [InverseProperty("CreditLimitCollateralBeneficiaries")]
    public virtual Counterparty Beneficiary { get; set; } = null!;

    [ForeignKey("CreditLimitCollateralId")]
    [InverseProperty("CreditLimitCollateralBeneficiaries")]
    public virtual CreditLimitCollateral CreditLimitCollateral { get; set; } = null!;
}
