using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("counterparty_relationship")]
[Index("CounterpartyId", "BusinessRelationshipId", Name = "uk_counterparty_relationship_counterparty", IsUnique = true)]
public partial class CounterpartyRelationship
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("counterparty_id")]
    public int CounterpartyId { get; set; }

    [Column("business_relationship_id")]
    public int BusinessRelationshipId { get; set; }

    [ForeignKey("BusinessRelationshipId")]
    [InverseProperty("CounterpartyRelationships")]
    public virtual BusinessRelationship BusinessRelationship { get; set; } = null!;

    [ForeignKey("CounterpartyId")]
    [InverseProperty("CounterpartyRelationships")]
    public virtual Counterparty Counterparty { get; set; } = null!;
}
