using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("counterparty_parent")]
[Index("CounterpartyId", "ParentId", Name = "uk_counterparty_parent", IsUnique = true)]
public partial class CounterpartyParent
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("counterparty_id")]
    public int CounterpartyId { get; set; }

    [Column("parent_id")]
    public int ParentId { get; set; }

    [Column("ownership_percent")]
    public decimal OwnershipPercent { get; set; }

    [ForeignKey("CounterpartyId")]
    [InverseProperty("CounterpartyParentCounterparties")]
    public virtual Counterparty Counterparty { get; set; } = null!;

    [ForeignKey("ParentId")]
    [InverseProperty("CounterpartyParentParents")]
    public virtual Counterparty Parent { get; set; } = null!;
}
