using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("contract_crude_point")]
public partial class ContractCrudePoint
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contract_crude_id")]
    public int ContractCrudeId { get; set; }

    [Column("point_id")]
    public int PointId { get; set; }

    [ForeignKey("ContractCrudeId")]
    [InverseProperty("ContractCrudePoints")]
    public virtual ContractCrude ContractCrude { get; set; } = null!;
}
